/** @file   menupage.cpp
 * @brief   Implementation of MenuPage - class.
 * @version $Revision: 1.2 $
 * @author  Tomi Lamminsaari
 */
 
#include "menupage.h"
#include <allegro.h>
#include "www_assert.h"
#include "eng2d.h"


namespace WeWantWar {


const int MenuPage::NO_PAGE_CHANGE;
const int MenuPage::PAGE_CHANGE;

const MenuPage::PageID MenuPage::MAINMENU;
const MenuPage::PageID MenuPage::SETTINGS;
const MenuPage::PageID MenuPage::LEVELCHANGE;
const MenuPage::PageID MenuPage::SAVESLOT;
const MenuPage::PageID MenuPage::LOADGAME;
const MenuPage::PageID MenuPage::NOTIFICATION;
const MenuPage::PageID MenuPage::HIGHSCORES;
const MenuPage::PageID MenuPage::ENTERHIGHSCORES;


int MenuPage::s_lastKey = KEY_O;


/** Constructor
 */
MenuPage::MenuPage() :
  m_selection( 0 ),
  m_state( STATE_FADEIN )
{
}

/** Destructor
 */
MenuPage::~MenuPage()
{
  // Destroy the overlayed items
  for ( int i=0; i < m_overlayedItems.size(); i++ ) {
    if ( m_overlayedItems.at(i) != 0 ) {
      delete m_overlayedItems.at(i);
      m_overlayedItems.at(i) = 0;
    }
  }
}


/** Redraws this menupage.
 */
void MenuPage::redrawPage()
{
  this->redraw();
  
  // Draw the overlayed items to the double buffer.
  for (int i=0; i < m_overlayedItems.size(); i++ ) {
    if ( m_overlayedItems.at(i) != 0 ) {
      m_overlayedItems.at(i)->redraw( eng2d::Display::buffer );
    }
  }
  
  // And finally flip the screen.
  eng2d::Display::flip();
}


/** Adds new overlayed item
 */
void MenuPage::addOverlayItem( OverlayItem* pItem )
{
  m_overlayedItems.push_back( pItem );
}


/** Returns the number of the item that has selection
 */
int MenuPage::getSelection() const
{
  return m_selection;
}


/** Returns the OverlayItem
 */
OverlayItem* MenuPage::getOverlayItem( int index ) const
{
  if ( index >= 0 && index < m_overlayedItems.size() ) {
    return m_overlayedItems.at( index );
  }
  return 0;
}


/** Returns the state
 */
MenuPage::ActionState MenuPage::getState() const
{
  return m_state;
}

} // end of namespace
